/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.client.container.StoneRollerContainer;
import cloud.lemonslice.teastory.recipe.stone_mill.StoneRollerRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.entity.NormalContainerBlockEntity;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneRollerBlockEntity
extends NormalContainerBlockEntity {
    private int woodenFrameAngel = 0;
    private int stoneAngel = 0;
    private boolean isWorking = false;
    private int processTicks = 0;
    private StoneRollerRecipe currentRecipe;
    private ItemStackHandler inputInventory = new SyncedBlockEntity.SyncedItemStackHandler(this);
    private ItemStackHandler outputInventory = new SyncedBlockEntity.SyncedItemStackHandler(this, 3);

    public StoneRollerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.STONE_ROLLER_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inputInventory.deserializeNBT(nbt.m_128469_("InputInventory"));
        this.outputInventory.deserializeNBT(nbt.m_128469_("OutputInventory"));
        this.processTicks = nbt.m_128451_("ProcessTicks");
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128365_("InputInventory", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInventory.serializeNBT());
        compound.m_128405_("ProcessTicks", this.processTicks);
        super.m_183515_(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (!this.m_58901_() && ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> this.outputInventory).cast();
            }
            return LazyOptional.of(() -> this.inputInventory).cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEmpty() {
        return this.inputInventory.getStackInSlot(0).m_41619_();
    }

    public ItemStack getStackInSlot(int index) {
        if (index == 0) {
            return this.inputInventory.getStackInSlot(0);
        }
        if (index > 0 && index < 4) {
            return this.outputInventory.getStackInSlot(index - 1);
        }
        return ItemStack.f_41583_;
    }

    public static void tick(Level worldIn, BlockPos pos, BlockState blockState, StoneRollerBlockEntity stoneRollerTileEntity) {
        ItemStack input = stoneRollerTileEntity.getStackInSlot(0);
        if (input.m_41619_()) {
            stoneRollerTileEntity.setProcessTicks(0);
            stoneRollerTileEntity.currentRecipe = null;
        }
        RecipeWrapper warp = new RecipeWrapper((IItemHandlerModifiable)stoneRollerTileEntity.inputInventory);
        if (stoneRollerTileEntity.currentRecipe == null || !stoneRollerTileEntity.currentRecipe.matches(warp, stoneRollerTileEntity.m_58904_())) {
            stoneRollerTileEntity.currentRecipe = stoneRollerTileEntity.m_58904_().m_7465_().m_44015_((RecipeType)RecipeRegister.STONE_ROLLER.get(), (Container)warp, stoneRollerTileEntity.m_58904_()).orElse(null);
        }
        if (stoneRollerTileEntity.currentRecipe != null) {
            stoneRollerTileEntity.woodenFrameAngel += 3;
            stoneRollerTileEntity.woodenFrameAngel %= 360;
            stoneRollerTileEntity.stoneAngel += 4;
            stoneRollerTileEntity.stoneAngel %= 360;
            stoneRollerTileEntity.isWorking = true;
            boolean flag = true;
            for (ItemStack out : stoneRollerTileEntity.currentRecipe.getOutputItems()) {
                if (ItemHandlerHelper.insertItem((IItemHandler)stoneRollerTileEntity.outputInventory, (ItemStack)out.m_41777_(), (boolean)true).m_41619_()) continue;
                flag = false;
            }
            if (flag && ++stoneRollerTileEntity.processTicks >= stoneRollerTileEntity.currentRecipe.getWorkTime()) {
                for (ItemStack out : stoneRollerTileEntity.currentRecipe.getOutputItems()) {
                    ItemHandlerHelper.insertItem((IItemHandler)stoneRollerTileEntity.outputInventory, (ItemStack)out.m_41777_(), (boolean)false);
                }
                stoneRollerTileEntity.inputInventory.extractItem(0, 1, false);
                stoneRollerTileEntity.processTicks = 0;
            }
        } else {
            stoneRollerTileEntity.setProcessTicks(0);
            stoneRollerTileEntity.isWorking = false;
        }
    }

    private void setProcessTicks(int ticks) {
        if (ticks != this.processTicks) {
            this.processTicks = ticks;
            this.m_6596_();
        }
    }

    public boolean isCompleted() {
        return this.currentRecipe == null;
    }

    public int getWoodenFrameAngel() {
        return this.woodenFrameAngel;
    }

    public int getStoneAngel() {
        return this.stoneAngel;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public int getProcessTicks() {
        return this.processTicks;
    }

    public StoneRollerRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p_39956_) {
        return new StoneRollerContainer(id, playerInventory, this.f_58858_, this.f_58857_);
    }
}

